/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.tables;

import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWReceiveInstruction;
import filenet.vw.api.VWWebServiceParameterDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.tables.IVWWSParamExpressionCellEditorTableModel;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import java.awt.ComponentOrientation;
import java.awt.Frame;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.table.AbstractTableModel;

public class VWReceiveWSOperationParameterTableModel
extends AbstractTableModel
implements IVWWSParamExpressionCellEditorTableModel {
    private static String ATTACH_BY_VALUE = null;
    private static String ATTACH_BY_VALUE_ARRAY = null;
    private static final String ARRAY = "[ ]";
    private final int NUM_COLUMNS = 3;
    public static final int COL_NAME = 0;
    public static final int COL_TYPE = 1;
    public static final int COL_FIELD = 2;
    private static final int DEFAULT_LEX_LEVEL = 1;
    private VWReceiveInstruction m_instructionDef = null;
    private Vector m_rowData = null;
    private JComboBox m_fieldTypeComboBox = null;
    private VWAuthPropertyData m_authPropertyData = null;
    private String m_type = null;
    private String m_fieldName = null;

    public VWReceiveWSOperationParameterTableModel(JDialog parentDialog, VWAuthPropertyData authPropertyData) {
        try {
            this.m_authPropertyData = authPropertyData;
            ATTACH_BY_VALUE = VWResource.s_byValue.toString(VWFieldType.getLocalizedString(32));
            ATTACH_BY_VALUE_ARRAY = VWResource.s_byValue.toString(VWFieldType.getLocalizedString(32) + ARRAY);
            this.m_rowData = new Vector();
            this.m_type = VWFieldType.getLocalizedString(4);
            this.m_fieldName = "";
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public VWReceiveWSOperationParameterTableModel(Frame parentFrame, VWAuthPropertyData authPropertyData) {
        try {
            this.m_authPropertyData = authPropertyData;
            ATTACH_BY_VALUE = VWResource.s_byValue.toString(VWFieldType.getLocalizedString(32));
            ATTACH_BY_VALUE_ARRAY = VWResource.s_byValue.toString(VWFieldType.getLocalizedString(32) + ARRAY);
            this.m_rowData = new Vector();
            this.m_type = VWFieldType.getLocalizedString(4);
            this.m_fieldName = "";
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public JComboBox getFieldTypeComboBox() {
        try {
            if (this.m_fieldTypeComboBox == null) {
                this.m_fieldTypeComboBox = new JComboBox();
                this.m_fieldTypeComboBox.setRenderer(new VWLabelListCellRenderer());
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(32));
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(32) + ARRAY);
                this.m_fieldTypeComboBox.addItem(ATTACH_BY_VALUE);
                this.m_fieldTypeComboBox.addItem(ATTACH_BY_VALUE_ARRAY);
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(4));
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(4) + ARRAY);
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(8));
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(8) + ARRAY);
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(1));
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(1) + ARRAY);
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(2));
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(2) + ARRAY);
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(16));
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(16) + ARRAY);
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(128));
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(128) + ARRAY);
                ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
                this.m_fieldTypeComboBox.applyComponentOrientation(compOrientation);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return this.m_fieldTypeComboBox;
    }

    public void deleteItem(int nRowIndex) {
        try {
            VWWebServiceParameterDefinition paramDef = this.getItemAt(nRowIndex);
            if (paramDef != null && this.m_authPropertyData != null && this.m_authPropertyData.getWorkflowDefinition() != null) {
                int corrParamSeqNum = this.m_instructionDef.getCorrelationParameterSequenceNumber();
                if (corrParamSeqNum != -1 && corrParamSeqNum == paramDef.getSequenceNumber()) {
                    this.m_instructionDef.setCorrelationParameterSequenceNumber(-1);
                    corrParamSeqNum = -1;
                }
                this.m_instructionDef.deleteParameter(paramDef.getSequenceNumber());
                this.m_rowData.removeElementAt(nRowIndex);
                for (int i = 0; i < this.m_rowData.size(); ++i) {
                    paramDef = this.getItemAt(i);
                    if (corrParamSeqNum != -1 && corrParamSeqNum == paramDef.getSequenceNumber()) {
                        paramDef.setSequenceNumber(i);
                        this.m_instructionDef.setCorrelationParameterSequenceNumber(i);
                        corrParamSeqNum = -1;
                        continue;
                    }
                    paramDef.setSequenceNumber(i);
                }
                this.fireTableRowsDeleted(nRowIndex, nRowIndex);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void reinitialize(VWReceiveInstruction instructionDef) {
        try {
            this.m_rowData.removeAllElements();
            this.m_instructionDef = instructionDef;
            if (this.m_instructionDef != null) {
                VWWebServiceParameterDefinition[] paramDefs = this.m_instructionDef.getParameterDefinitions();
                if (paramDefs != null && paramDefs.length > 0) {
                    Vector<Integer> paramsToRemove = new Vector<Integer>();
                    for (int i = 0; i < paramDefs.length; ++i) {
                        if (paramDefs[i].getLexicalLevel() == 1) {
                            this.m_rowData.addElement(paramDefs[i]);
                            continue;
                        }
                        paramsToRemove.add(new Integer(paramDefs[i].getSequenceNumber()));
                    }
                    if (paramsToRemove.size() > 0) {
                        int i;
                        VWWebServiceParameterDefinition referencedParam = null;
                        int corrParamSeqNum = this.m_instructionDef.getCorrelationParameterSequenceNumber();
                        if (corrParamSeqNum != -1) {
                            for (i = 0; i < paramDefs.length; ++i) {
                                if (paramDefs[i].getSequenceNumber() != corrParamSeqNum) continue;
                                referencedParam = paramDefs[i];
                                break;
                            }
                        }
                        for (i = 0; i < paramsToRemove.size(); ++i) {
                            Integer seqNum = (Integer)paramsToRemove.elementAt(i);
                            if (seqNum == null) continue;
                            this.m_instructionDef.deleteParameter(seqNum);
                        }
                        for (i = 0; i < this.m_rowData.size(); ++i) {
                            VWWebServiceParameterDefinition paramDef = this.getItemAt(i);
                            if (paramDef == null) continue;
                            paramDef.setSequenceNumber(i);
                            if (referencedParam == null || !referencedParam.equals(paramDef)) continue;
                            this.m_instructionDef.setCorrelationParameterSequenceNumber(paramDef.getSequenceNumber());
                            referencedParam = null;
                        }
                    }
                }
                this.fireTableDataChanged();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return 3;
    }

    public String getColumnName(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return VWResource.s_nameStr;
            }
            case 1: {
                return VWResource.s_typeStr;
            }
            case 2: {
                return VWResource.s_fieldNameStr;
            }
        }
        return null;
    }

    public int getRowCount() {
        if (this.m_rowData != null) {
            return this.m_rowData.size() + 1;
        }
        return 0;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        try {
            VWWebServiceParameterDefinition paramDef = this.getItemAt(nRowIndex);
            switch (nColumnIndex) {
                case 0: {
                    if (paramDef == null) break;
                    return paramDef.getName();
                }
                case 1: {
                    return this.getTypeFromParam(paramDef);
                }
                case 2: {
                    if (paramDef != null) {
                        return paramDef.getValue();
                    }
                    return this.m_fieldName;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        try {
            switch (nColumnIndex) {
                case 0: {
                    this.onUpdateParamName(aValue, nRowIndex);
                    break;
                }
                case 1: {
                    this.onUpdateParamType(aValue, nRowIndex);
                    break;
                }
                case 2: {
                    this.onUpdateParamValue(aValue, nRowIndex);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public VWWebServiceParameterDefinition getItemAt(int nRowIndex) {
        if (this.m_rowData == null || nRowIndex < 0) {
            return null;
        }
        if (nRowIndex < this.m_rowData.size()) {
            return (VWWebServiceParameterDefinition)this.m_rowData.elementAt(nRowIndex);
        }
        return null;
    }

    public int getParameterType(int nRowIndex) {
        VWWebServiceParameterDefinition paramDef = this.getItemAt(nRowIndex);
        if (paramDef != null) {
            return paramDef.getDataType();
        }
        return this.getFieldType(this.m_type);
    }

    public boolean getIsArray(int nRowIndex) {
        VWWebServiceParameterDefinition paramDef = this.getItemAt(nRowIndex);
        if (paramDef != null) {
            return paramDef.getIsArray();
        }
        return this.isArrayType(this.m_type);
    }

    public int getMode(int nRowIndex) {
        VWWebServiceParameterDefinition paramDef = this.getItemAt(nRowIndex);
        if (paramDef != null) {
            return paramDef.getMode();
        }
        return 2;
    }

    private void onUpdateParamName(Object aValue, int nRowIndex) {
        try {
            if (aValue == null) {
                return;
            }
            String newName = (String)aValue;
            VWWebServiceParameterDefinition paramDef = this.getItemAt(nRowIndex);
            if (paramDef != null) {
                String oldName = paramDef.getName();
                if (VWStringUtils.compare(newName, oldName) != 0) {
                    paramDef.setName(newName);
                    this.m_authPropertyData.setDirty();
                    this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                }
            } else {
                paramDef = this.m_instructionDef.createParameter(newName, this.m_fieldName, this.getFieldType(this.m_type), this.isArrayType(this.m_type));
                if (paramDef != null) {
                    if (paramDef.getDataType() == 32) {
                        paramDef.setAttachmentByValue(this.isAttachmentByValue(this.m_type));
                    }
                    this.m_rowData.addElement(paramDef);
                    this.m_authPropertyData.setDirty();
                    paramDef.setLexicalLevel(1);
                    paramDef.setSequenceNumber(this.m_rowData.size() - 1);
                    this.m_type = VWFieldType.getLocalizedString(4);
                    this.m_fieldName = "";
                    this.fireTableRowsInserted(nRowIndex, nRowIndex + 1);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onUpdateParamType(Object aValue, int nRowIndex) {
        try {
            if (aValue != null) {
                String type = aValue.toString();
                VWWebServiceParameterDefinition paramDef = this.getItemAt(nRowIndex);
                if (paramDef != null) {
                    paramDef.setDataType(this.getFieldType(type));
                    paramDef.setIsArray(this.isArrayType(type));
                    if (paramDef.getDataType() == 32) {
                        paramDef.setAttachmentByValue(this.isAttachmentByValue(type));
                    }
                    this.m_authPropertyData.setDirty();
                } else {
                    this.m_type = type;
                }
            }
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onUpdateParamValue(Object aValue, int nRowIndex) {
        try {
            if (aValue != null) {
                String fieldName = (String)aValue;
                VWWebServiceParameterDefinition paramDef = this.getItemAt(nRowIndex);
                if (paramDef != null) {
                    paramDef.setValue(fieldName);
                    this.m_authPropertyData.setDirty();
                } else {
                    this.m_fieldName = fieldName;
                }
            }
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
        }
    }

    private int getFieldType(String type) {
        try {
            if (VWStringUtils.compare(type, VWFieldType.getLocalizedString(32)) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(32) + ARRAY) == 0 || VWStringUtils.compare(type, ATTACH_BY_VALUE) == 0 || VWStringUtils.compare(type, ATTACH_BY_VALUE_ARRAY) == 0) {
                return 32;
            }
            if (VWStringUtils.compare(type, VWFieldType.getLocalizedString(4)) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(4) + ARRAY) == 0) {
                return 4;
            }
            if (VWStringUtils.compare(type, VWFieldType.getLocalizedString(8)) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(8) + ARRAY) == 0) {
                return 8;
            }
            if (VWStringUtils.compare(type, VWFieldType.getLocalizedString(1)) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(1) + ARRAY) == 0) {
                return 1;
            }
            if (VWStringUtils.compare(type, VWFieldType.getLocalizedString(2)) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(2) + ARRAY) == 0) {
                return 2;
            }
            if (VWStringUtils.compare(type, VWFieldType.getLocalizedString(16)) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(16) + ARRAY) == 0) {
                return 16;
            }
            if (VWStringUtils.compare(type, VWFieldType.getLocalizedString(128)) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(128) + ARRAY) == 0) {
                return 128;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return -1;
    }

    private boolean isAttachmentByValue(String type) {
        return type != null && (VWStringUtils.compare(type, ATTACH_BY_VALUE) == 0 || VWStringUtils.compare(type, ATTACH_BY_VALUE_ARRAY) == 0);
    }

    private Object getTypeFromParam(VWWebServiceParameterDefinition paramDef) {
        try {
            if (paramDef != null) {
                if (paramDef.getDataType() == 32 && paramDef.isAttachmentByValue()) {
                    if (paramDef.getIsArray()) {
                        return ATTACH_BY_VALUE_ARRAY;
                    }
                    return ATTACH_BY_VALUE;
                }
                StringBuffer buffer = new StringBuffer(VWFieldType.getLocalizedString(paramDef.getDataType()));
                if (paramDef.getIsArray()) {
                    buffer.append(ARRAY);
                }
                return buffer.toString();
            }
            return this.m_type;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private boolean isArrayType(String type) {
        try {
            if (VWStringUtils.compare(type, VWFieldType.getLocalizedString(32) + ARRAY) == 0 || VWStringUtils.compare(type, ATTACH_BY_VALUE_ARRAY) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(4) + ARRAY) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(8) + ARRAY) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(1) + ARRAY) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(2) + ARRAY) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(16) + ARRAY) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(128) + ARRAY) == 0) {
                return true;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return false;
    }
}

